#!/bin/sh
#
# Generates the NKSP instrument script parser's C++ source files
# (parser.tab.h, parser.tab.cpp and scanner.cpp in and src/scriptvm/) according to the
# NKSP instrument script (BNF) grammar definition given by src/scriptvm/parser.y and
# the terminal symbol scanner/lexer defintion given by src/scriptvm/scanner.l

SCRIPTS_DIR=`dirname $0`
PARSER_SRC_DIR="$SCRIPTS_DIR/../src/scriptvm"

echo -n "Searching for lexer and parser generator..."

FLEX_CMD=NONE
if which "flex" > /dev/null; then
    FLEX_CMD=`which flex`
else
    echo "Error: You need flex to generate the NKSP instrument script parser !"
    exit -1
fi

BISON_BIN=NONE
BISON_CMD=NONE
if which "bison" > /dev/null; then
    BISON_BIN=`which bison`
    bison_version=`bison --version | head -n 1 | sed -e 's/[^0-9.]*\([-0-9.]\+\)$/\1/'`
    bison_version_major=`echo $bison_version | cut -d. -f1`
    bison_version_minor=`echo $bison_version | cut -d. -f2`
    if [ "$bison_version_major" -gt "2" ]; then
        # Keep backward compatibility to Bison 2, therefore silence
        # Bison 3 warnings about deprecated features.
        # Treat all grammar conflicts as error.
        BISON_CMD="$BISON_BIN -Wno-deprecated -Werror=conflicts-sr -Werror=conflicts-rr -Wcounterexamples"
    else
        BISON_CMD="$BISON_BIN"
    fi
else
    echo "Error: You need GNU Bison to generate the NKSP instrument script parser !"
    exit -1
fi

echo "OK ($FLEX_CMD, $BISON_BIN)"

echo -n "Generating NKSP instrument script parser ... "
(
    cd $PARSER_SRC_DIR

    $FLEX_CMD -o scanner.cpp scanner.l
    $BISON_CMD -o parser.tab.cpp --defines=parser.tab.h parser.y
)
res=$?
echo "Done"
exit $res
